/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudios.libraryferret.conf;

import com.google.common.collect.Lists;
import com.jtorleonstudios.libraryferret.LibraryFerret;
import com.jtorleonstudios.libraryferret.conf.Configuration;
import com.jtorleonstudios.libraryferret.conf.Props;
import com.jtorleonstudios.libraryferret.gui.AbstractScreen;
import com.jtorleonstudios.libraryferret.gui.AbstractUI;
import com.jtorleonstudios.libraryferret.gui.ScrollableTextUI;
import com.jtorleonstudios.libraryferret.utils.Color;
import com.mojang.blaze3d.platform.InputConstants;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.loading.StringUtils;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public final class ConfigurationScreen
extends AbstractScreen {
    private final Screen lastScreen;
    private boolean hasPropsChanged = false;
    private int listWidth;
    private final Map<String, List<Props>> propsByGroups;
    private Props currentPropsDisplayed = null;
    private List<WidgetStringList.StringEntry> currentListDisplay;
    private List<WidgetStringList.StringEntry> unsortedCurrentListDisplay;
    private String lastFilterText = "";
    private WidgetStringList propsGroupSelectionList;
    private AbstractUI rightSection;
    private EditBox search;
    private Button btnSwapList;
    private Button btnDone;
    private int rightSectionWidth;
    private final Configuration config;

    public ConfigurationScreen(Screen parentScreen, String modID, Configuration cfg) {
        super((Component)Component.m_237115_((String)("gui.jtorleonstudios." + modID + ".configscreen.title")));
        this.lastScreen = parentScreen;
        this.propsByGroups = new HashMap<String, List<Props>>();
        this.config = cfg;
        this.config.getPropsRegistry().values().forEach(v -> {
            if (!this.propsByGroups.containsKey(v.getGroup())) {
                ArrayList<Props> l = new ArrayList<Props>();
                l.add((Props)v);
                this.propsByGroups.put(v.getGroup(), l);
            } else {
                this.propsByGroups.get(v.getGroup()).add((Props)v);
            }
        });
    }

    public void m_7856_() {
        this.listWidth = 0;
        this.propsByGroups.forEach((group, propsList) -> {
            int i1 = Math.max(this.listWidth, this.f_96547_.m_92852_((FormattedText)Component.m_237115_((String)("gui.libraryferret.group.name." + group))) + 10);
            if (i1 > this.listWidth) {
                this.listWidth = i1;
            }
            propsList.forEach(props -> {
                int i2 = Math.max(this.listWidth, this.f_96547_.m_92852_((FormattedText)Component.m_237115_((String)("gui.libraryferret.props.name." + props.getKey()))) + 10);
                if (i2 > this.listWidth) {
                    this.listWidth = i2;
                }
            });
        });
        this.listWidth = Math.max(Math.min(this.listWidth, this.f_96543_ / 3), 100);
        this.rightSectionWidth = this.f_96543_ - this.listWidth - 18;
        int doneButtonWidth = Math.min(this.rightSectionWidth, 200);
        int y = this.f_96544_ - 20 - 6;
        this.btnDone = Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), b -> {
            if (this.btnDone.m_6035_().equals(Component.m_237115_((String)"gui.done"))) {
                this.m_7379_();
            } else {
                this.propsGroupSelectionList.swap();
            }
        }).m_252987_((this.listWidth + 6 + this.f_96543_ - doneButtonWidth) / 2, y, doneButtonWidth, 20).m_253136_();
        Button openFile = Button.m_253074_((Component)Component.m_237115_((String)"gui.libraryferret.openconfigfile"), b -> Util.m_137581_().m_137644_(new File(this.config.getPropertiesPath()))).m_252987_(6, y, this.listWidth, 20).m_253136_();
        this.btnSwapList = Button.m_253074_((Component)Component.m_237115_((String)"menu.options"), b -> {
            if (this.rightSection instanceof WelcomeSection && this.btnSwapList.m_6035_().equals(Component.m_237115_((String)"gui.back"))) {
                ((WelcomeSection)this.rightSection).resetWelcomeText();
            }
            this.propsGroupSelectionList.swap();
        }).m_252987_(6, y -= 26, this.listWidth, 20).m_253136_();
        this.search = new EditBox(this.f_96547_, 7, y -= 21, this.listWidth - 2, 14, (Component)Component.m_237115_((String)"gui.libraryferret.search"));
        this.propsGroupSelectionList = new WidgetStringList(this.listWidth, 6, this.search.m_252907_() - 9 - 6);
        this.propsGroupSelectionList.m_93507_(6);
        this.rightSection = this.currentPropsDisplayed == null ? new WelcomeSection(this, this.listWidth + 12, 6, this.rightSectionWidth, this.btnDone.m_252907_() - 12) : new PropsSection(this, this.currentPropsDisplayed, this.listWidth + 12, 6, this.rightSectionWidth, this.btnDone.m_252907_() - 12);
        this.m_142416_((GuiEventListener)this.propsGroupSelectionList);
        this.m_142416_(this.rightSection);
        this.m_142416_((GuiEventListener)this.search);
        this.m_142416_((GuiEventListener)this.btnDone);
        this.m_142416_((GuiEventListener)openFile);
        this.m_142416_((GuiEventListener)this.btnSwapList);
        this.search.m_93692_(true);
        this.search.m_94190_(true);
    }

    public void m_88315_(@NotNull GuiGraphics ctx, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(ctx, mouseX, mouseY, partialTicks);
        MutableComponent text = Component.m_237115_((String)"gui.libraryferret.search");
        int x = this.propsGroupSelectionList.getLeft() + (this.propsGroupSelectionList.getRight() - this.propsGroupSelectionList.getLeft()) / 2 - this.f_96547_.m_92852_((FormattedText)text) / 2;
        ctx.drawString(this.getFontRenderer(), text.m_7532_(), (float)x, (float)(this.search.m_252907_() - 9), 0xFFFFFF, true);
    }

    public void m_86600_() {
        this.search.m_94120_();
        this.rightSection.tick();
        if (!this.search.m_94155_().equals(this.lastFilterText)) {
            this.reloadProps();
            this.propsGroupSelectionList.refreshList();
        }
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            if (this.hasPropsChanged) {
                this.f_96541_.m_91152_((Screen)new ConfirmScreen(b -> {
                    if (b) {
                        this.config.save();
                    }
                    this.f_96541_.m_91152_(this.lastScreen);
                }, (Component)Component.m_237115_((String)"gui.libraryferret.requiresave.title"), (Component)Component.m_237115_((String)"gui.libraryferret.requiresave.message")));
            } else {
                this.f_96541_.m_91152_(this.lastScreen);
            }
        } else {
            this.config.save();
        }
    }

    public void m_6574_(@NotNull Minecraft mc, int width, int height) {
        String s = this.search.m_94155_();
        this.m_6575_(mc, width, height);
        this.search.m_94144_(s);
        if (!this.search.m_94155_().isEmpty()) {
            this.reloadProps();
        }
    }

    private void reloadProps() {
        this.currentListDisplay = this.unsortedCurrentListDisplay.stream().filter(v -> StringUtils.toLowerCase((String)StringUtil.m_14406_((String)v.value)).contains(StringUtils.toLowerCase((String)this.search.m_94155_()))).collect(Collectors.toList());
        this.lastFilterText = this.search.m_94155_();
    }

    private void setCurrentPropsDisplayed(@Nullable Props p) {
        this.m_169411_(this.rightSection);
        this.currentPropsDisplayed = p;
        this.rightSection = this.currentPropsDisplayed == null ? new WelcomeSection(this, this.listWidth + 12, 6, this.rightSectionWidth, this.btnDone.m_252907_() - 12) : new PropsSection(this, this.currentPropsDisplayed, this.listWidth + 12, 6, this.rightSectionWidth, this.btnDone.m_252907_() - 12);
        this.m_142416_(this.rightSection);
    }

    private void setCurrentListDisplayed(List<WidgetStringList.StringEntry> v) {
        this.currentListDisplay = Collections.unmodifiableList(v);
        this.unsortedCurrentListDisplay = this.currentListDisplay;
    }

    protected class WidgetStringList
    extends ObjectSelectionList<StringEntry> {
        private boolean currentListIsGroup;

        public WidgetStringList(int listWidth, int top, int bottom) {
            super(ConfigurationScreen.this.f_96541_, listWidth, ConfigurationScreen.this.f_96544_, top, bottom, ConfigurationScreen.this.getLineHeight() + 8);
            this.currentListIsGroup = true;
            this.displayGroupEntry();
        }

        private void select(StringEntry entry) {
            StringEntry lastSelected = (StringEntry)this.m_93511_();
            super.m_6987_((AbstractSelectionList.Entry)entry);
            if (this.currentListIsGroup) {
                ConfigurationScreen.this.btnSwapList.f_93623_ = true;
                if (entry.equals((Object)lastSelected)) {
                    this.swap();
                } else {
                    ((WelcomeSection)ConfigurationScreen.this.rightSection).welcome.setTexts(I18n.m_118938_((String)("gui.libraryferret.group.description." + entry.keyGroup), (Object[])new Object[0]));
                }
            } else if (ConfigurationScreen.this.config.getPropsRegistry().containsKey(entry.keyProps)) {
                ConfigurationScreen.this.setCurrentPropsDisplayed(ConfigurationScreen.this.config.getPropsRegistry().get(entry.keyProps));
            } else {
                LibraryFerret.LOGGER.error("The props list do not contains the selected props (" + entry + ") ! Please if you see this message open a issues on Github");
            }
        }

        private void swap() {
            if (ConfigurationScreen.this.currentPropsDisplayed != null) {
                ConfigurationScreen.this.setCurrentPropsDisplayed(null);
            }
            if (this.currentListIsGroup) {
                if (this.m_93511_() != null) {
                    if (ConfigurationScreen.this.propsByGroups.containsKey(((StringEntry)this.m_93511_()).keyGroup)) {
                        this.currentListIsGroup = false;
                        this.displayKeyEntry(((StringEntry)this.m_93511_()).keyGroup);
                    } else {
                        LibraryFerret.LOGGER.error("The group list do not contains the selected group (" + ((StringEntry)this.m_93511_()).toString() + ") ! Please if you see this message open a issues on Github");
                    }
                } else {
                    LibraryFerret.LOGGER.error("The selection is null (" + this.m_93511_() + ") ! Please if you see this message open a issues on Github");
                }
            } else {
                this.currentListIsGroup = true;
                this.displayGroupEntry();
            }
        }

        private void displayGroupEntry() {
            this.m_93516_();
            ArrayList<StringEntry> l = new ArrayList<StringEntry>();
            ConfigurationScreen.this.propsByGroups.keySet().forEach(k -> {
                l.add(new StringEntry("gui.libraryferret.group.name." + k, (String)k, null));
                this.m_7085_((AbstractSelectionList.Entry)new StringEntry("gui.libraryferret.group.name." + k, (String)k, null));
            });
            ConfigurationScreen.this.setCurrentListDisplayed(l);
            ConfigurationScreen.this.btnSwapList.m_93666_((Component)Component.m_237115_((String)"menu.options"));
            ConfigurationScreen.this.btnDone.m_93666_((Component)Component.m_237115_((String)"gui.done"));
            ConfigurationScreen.this.btnSwapList.f_93623_ = false;
        }

        private void displayKeyEntry(String keyGroup) {
            this.m_93516_();
            ArrayList<StringEntry> l = new ArrayList<StringEntry>();
            ConfigurationScreen.this.propsByGroups.get(keyGroup).forEach(v -> {
                l.add(new StringEntry("gui.libraryferret.props.name." + v.getKey(), null, v.getKey()));
                this.m_7085_((AbstractSelectionList.Entry)new StringEntry("gui.libraryferret.props.name." + v.getKey(), null, v.getKey()));
            });
            ConfigurationScreen.this.setCurrentListDisplayed(l);
            ConfigurationScreen.this.btnSwapList.m_93666_((Component)Component.m_237115_((String)"gui.back"));
            ConfigurationScreen.this.btnDone.m_93666_((Component)Component.m_237115_((String)"gui.back"));
            ConfigurationScreen.this.btnSwapList.f_93623_ = true;
        }

        public void refreshList() {
            this.m_93516_();
            ConfigurationScreen.this.currentListDisplay.forEach(x$0 -> this.m_7085_((AbstractSelectionList.Entry)x$0));
        }

        protected int m_5756_() {
            return ConfigurationScreen.this.listWidth;
        }

        public int m_5759_() {
            return ConfigurationScreen.this.listWidth;
        }

        protected void m_7733_(@NotNull GuiGraphics ctx) {
            ConfigurationScreen.this.m_280273_(ctx);
        }

        public boolean m_93696_() {
            return ConfigurationScreen.this.m_7222_() == this;
        }

        public final class StringEntry
        extends ObjectSelectionList.Entry<StringEntry> {
            private final String value;
            private final String keyGroup;
            private final String keyProps;

            public StringEntry(String value, String keyGroup, String keyProps) {
                this.value = value;
                this.keyGroup = keyGroup;
                this.keyProps = keyProps;
            }

            public void m_6311_(@NotNull GuiGraphics ctx, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
                MutableComponent n = Component.m_237115_((String)this.value);
                ctx.drawString(ConfigurationScreen.this.getFontRenderer(), Language.m_128107_().m_5536_(FormattedText.m_130773_((FormattedText[])new FormattedText[]{ConfigurationScreen.this.f_96547_.m_92854_((FormattedText)n, ConfigurationScreen.this.listWidth)})), (float)(left + 3), (float)(top + 2), 0xFFFFFF, true);
            }

            @NotNull
            public Component m_142172_() {
                return Component.m_237110_((String)"narrator.select", (Object[])new Object[]{this.value});
            }

            public boolean m_6375_(double a, double b, int c) {
                if (c == 0) {
                    WidgetStringList.this.select(this);
                    return true;
                }
                return false;
            }

            public String toString() {
                return "StringEntry{value='" + this.value + "', keyGroup='" + this.keyGroup + "', keyProps='" + this.keyProps + "'}";
            }

            public int hashCode() {
                int result = 1;
                result = 31 * result + ((Object)((Object)this.getEnclosingInstance())).hashCode();
                result = 31 * result + Objects.hash(this.keyGroup, this.keyProps, this.value);
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (((Object)((Object)this)).getClass() != obj.getClass()) {
                    return false;
                }
                StringEntry other = (StringEntry)((Object)obj);
                if (!((Object)((Object)this.getEnclosingInstance())).equals((Object)other.getEnclosingInstance())) {
                    return false;
                }
                return Objects.equals(this.keyGroup, other.keyGroup) && Objects.equals(this.keyProps, other.keyProps) && Objects.equals(this.value, other.value);
            }

            private WidgetStringList getEnclosingInstance() {
                return WidgetStringList.this;
            }
        }
    }

    private final class WelcomeSection
    extends AbstractUI {
        private final List<GuiEventListener> children;
        private final ScrollableTextUI welcome;

        public WelcomeSection(AbstractScreen parent, int x, int y, int w, int h) {
            super(parent, x, y, w, h);
            this.children = Lists.newArrayList();
            this.welcome = new ScrollableTextUI(ConfigurationScreen.this, I18n.m_118938_((String)"gui.libraryferret.config_welcome", (Object[])new Object[0]), x, 6, w, this.bottom - 6);
            this.children.add(this.welcome);
        }

        private void resetWelcomeText() {
            this.welcome.setTexts(I18n.m_118938_((String)"gui.libraryferret.config_welcome", (Object[])new Object[0]));
        }

        public void m_88315_(@NotNull GuiGraphics ctx, int mouseX, int mouseY, float partialTicks) {
            this.renderBackground();
            this.welcome.m_88315_(ctx, mouseX, mouseY, partialTicks);
        }

        @Override
        @NotNull
        public List<? extends GuiEventListener> m_6702_() {
            return this.children;
        }
    }

    private class PropsSection
    extends AbstractUI {
        private final List<GuiEventListener> children;
        private final Button btnReset;
        private final ScrollableTextUI description;
        private final Props props;
        private final MutableComponent textLine1;
        private final MutableComponent textLine2;
        private final MutableComponent textLine3;
        private final MutableComponent textLine4;
        @Nullable
        private EditBox input;
        @Nullable
        private Button inputButton;
        @Nullable
        private AbstractSliderButton slide;

        public PropsSection(AbstractScreen parent, Props propsDisplayed, int x, int y, int w, int h) {
            super(parent, x, y, w, h);
            this.children = Lists.newArrayList();
            this.input = null;
            this.inputButton = null;
            this.slide = null;
            this.props = propsDisplayed;
            this.textLine1 = Component.m_237110_((String)"gui.libraryferret.props.title_value", (Object[])new Object[]{Component.m_237115_((String)("gui.libraryferret.props.name." + this.props.getKey()))});
            this.textLine2 = Component.m_237110_((String)"gui.libraryferret.props.key_value", (Object[])new Object[]{this.props.getKey()});
            this.textLine3 = Component.m_237110_((String)"gui.libraryferret.props.default_value", (Object[])new Object[]{this.props.getDefaultValue()});
            this.textLine4 = Component.m_237110_((String)"gui.libraryferret.props.type_value", (Object[])new Object[]{this.props.getType()});
            int numberLinesBeforeInput = 4;
            int inputWidth = this.width / 2;
            int inputX = this.x + 6;
            Objects.requireNonNull(ConfigurationScreen.this.f_96547_);
            int inputY = 12 + 15 * numberLinesBeforeInput;
            if (this.props.getType().contains("boolean")) {
                ConfigurationScreen configurationScreen2 = ConfigurationScreen.this;
                Objects.requireNonNull(configurationScreen2);
                this.inputButton = configurationScreen2.new OptionToggleWidget(inputX, inputY, inputWidth, this.props);
                this.children.add((GuiEventListener)this.inputButton);
            } else if (!(this.props.getType().contains("number") || this.props.getType().contains("int") || this.props.getType().contains("double") || this.props.getType().contains("float") || this.props.getType().contains("long"))) {
                if (!this.props.getType().contains("item") && !this.props.getType().contains("block")) {
                    if (this.props.getType().contains("color")) {
                        ConfigurationScreen configurationScreen3 = ConfigurationScreen.this;
                        Objects.requireNonNull(configurationScreen3);
                        this.input = configurationScreen3.new OptionColorTextWidget(inputX += 26, inputY, inputWidth, this.props);
                        this.children.add((GuiEventListener)this.input);
                    } else if (!this.props.getType().contains("key") && !this.props.getType().contains("input")) {
                        ConfigurationScreen configurationScreen4 = ConfigurationScreen.this;
                        Objects.requireNonNull(configurationScreen4);
                        this.input = configurationScreen4.new OptionTextWidget(inputX, inputY, inputWidth, this.props);
                        if (this.props.getType().contains("char")) {
                            this.input.m_94199_(1);
                        }
                        this.children.add((GuiEventListener)this.input);
                    } else {
                        ConfigurationScreen configurationScreen5 = ConfigurationScreen.this;
                        Objects.requireNonNull(configurationScreen5);
                        this.inputButton = configurationScreen5.new OptionKeyBindWidget(inputX, inputY, inputWidth, this.props);
                        this.children.add((GuiEventListener)this.inputButton);
                    }
                } else {
                    ConfigurationScreen configurationScreen6 = ConfigurationScreen.this;
                    Objects.requireNonNull(configurationScreen6);
                    this.input = configurationScreen6.new OptionItemStackTextWidget(inputX += 26, inputY, inputWidth, this.props);
                    this.children.add((GuiEventListener)this.input);
                }
            } else {
                ConfigurationScreen configurationScreen7 = ConfigurationScreen.this;
                Objects.requireNonNull(configurationScreen7);
                this.slide = configurationScreen7.new OptionSliderWidget(inputX, inputY, inputWidth, this.props);
                this.children.add((GuiEventListener)this.slide);
            }
            int btnResetX = inputX + inputWidth + 6;
            this.btnReset = Button.m_253074_((Component)Component.m_237115_((String)"controls.reset"), e -> {
                ConfigurationScreen.this.config.reset(this.props);
                ConfigurationScreen.this.setCurrentPropsDisplayed(this.props);
                if (!ConfigurationScreen.this.hasPropsChanged) {
                    ConfigurationScreen.this.hasPropsChanged = true;
                }
            }).m_252987_(btnResetX, inputY, this.right - btnResetX - 6, 20).m_253136_();
            this.children.add((GuiEventListener)this.btnReset);
            int descriptionY = inputY + 20 + 6;
            this.description = new ScrollableTextUI(ConfigurationScreen.this, I18n.m_118938_((String)("gui.libraryferret.props.description." + this.props.getKey()), (Object[])new Object[0]), x, descriptionY, w, this.bottom - descriptionY);
            this.children.add(this.description);
        }

        public void m_88315_(@NotNull GuiGraphics ctx, int mouseX, int mouseY, float partialTicks) {
            this.renderBackground();
            float y = this.y + 6;
            ctx.m_280614_(ConfigurationScreen.this.getFontRenderer(), (Component)this.textLine1, this.left + 6, (int)y, 0xFFFFFF, true);
            ctx.m_280614_(ConfigurationScreen.this.getFontRenderer(), (Component)this.textLine2, this.left + 6, (int)(y += (float)(this.parent.getLineHeight() + 6)), 0xFFFFFF, true);
            ctx.m_280614_(ConfigurationScreen.this.getFontRenderer(), (Component)this.textLine3, this.left + 6, (int)(y += (float)(this.parent.getLineHeight() + 6)), 0xFFFFFF, true);
            ctx.m_280614_(ConfigurationScreen.this.getFontRenderer(), (Component)this.textLine4, this.left + 6, (int)(y += (float)(this.parent.getLineHeight() + 6)), 0xFFFFFF, true);
            if (this.input != null) {
                this.input.m_88315_(ctx, mouseX, mouseY, partialTicks);
            } else if (this.inputButton != null) {
                this.inputButton.m_88315_(ctx, mouseX, mouseY, partialTicks);
            } else if (this.slide != null) {
                this.slide.m_88315_(ctx, mouseX, mouseY, partialTicks);
            }
            this.btnReset.m_88315_(ctx, mouseX, mouseY, partialTicks);
            this.description.m_88315_(ctx, mouseX, mouseY, partialTicks);
        }

        @Override
        public void tick() {
            if (this.input != null) {
                this.input.m_94120_();
            }
        }

        @Override
        @NotNull
        public List<? extends GuiEventListener> m_6702_() {
            return this.children;
        }
    }

    private class OptionTextWidget
    extends EditBox {
        protected final Props props;

        public OptionTextWidget(int x, int y, int w, Props props) {
            super(ConfigurationScreen.this.f_96547_, x, y, w, 20, (Component)Component.m_237115_((String)""));
            this.props = props;
            this.m_94144_(ConfigurationScreen.this.config.getStringOrDefault(props));
            this.m_94151_(this::valueChanged);
        }

        private void valueChanged(String value) {
            ConfigurationScreen.this.config.set(this.props, value);
            if (!ConfigurationScreen.this.hasPropsChanged) {
                ConfigurationScreen.this.hasPropsChanged = true;
            }
        }
    }

    private class OptionColorTextWidget
    extends OptionTextWidget {
        public OptionColorTextWidget(int x, int y, int w, Props props) {
            super(x, y, w, props);
            this.m_94151_(this::valueChanged);
        }

        public void m_88315_(@NotNull GuiGraphics ctx, int mouseX, int mouseY, float partialTicks) {
            super.m_88315_(ctx, mouseX, mouseY, partialTicks);
            int quadX = this.m_252754_() - 6 - this.m_93694_();
            int quadY = this.m_252907_();
            ctx.m_280509_(quadX - 1, quadY - 1, this.m_252754_() - 6 + 1, this.m_252907_() + this.m_93694_() + 1, this.m_93696_() ? -1 : -6250336);
            ctx.m_280509_(quadX, quadY, this.m_252754_() - 6, this.m_252907_() + this.m_93694_(), Color.toHex(this.m_94155_()));
        }

        private void valueChanged(String value) {
            ConfigurationScreen.this.config.set(this.props, Color.isRGBorRGBA(value) ? Color.toString(Color.toRGBA(value)) : Color.toString(0, 0, 0, 255));
            if (!ConfigurationScreen.this.hasPropsChanged) {
                ConfigurationScreen.this.hasPropsChanged = true;
            }
        }
    }

    private class OptionItemStackTextWidget
    extends OptionTextWidget {
        public OptionItemStackTextWidget(int x, int y, int w, Props props) {
            super(x, y, w, props);
            this.m_94151_(this::valueChanged);
        }

        public void m_88315_(@NotNull GuiGraphics ctx, int mouseX, int mouseY, float partialTicks) {
            super.m_88315_(ctx, mouseX, mouseY, partialTicks);
            int quadX = this.m_252754_() - 6 - this.m_93694_();
            int quadY = this.m_252907_();
            ctx.m_280509_(quadX - 1, quadY - 1, this.m_252754_() - 6 + 1, this.m_252907_() + this.m_93694_() + 1, this.m_93696_() ? -1 : -6250336);
            ctx.m_280509_(quadX, quadY, this.m_252754_() - 6, this.m_252907_() + this.m_93694_(), Color.BLACK);
            ResourceLocation test = new ResourceLocation(this.m_94155_());
            ItemStack itemstack = new ItemStack((ItemLike)(ForgeRegistries.ITEMS.containsKey(test) ? (ItemLike)ForgeRegistries.ITEMS.getValue(test) : Items.f_42127_));
            ctx.m_280480_(itemstack, quadX + 2, quadY + 2);
        }

        private void valueChanged(String value) {
            if (ForgeRegistries.ITEMS.containsKey(new ResourceLocation(this.m_94155_()))) {
                ConfigurationScreen.this.config.set(this.props, value);
                if (!ConfigurationScreen.this.hasPropsChanged) {
                    ConfigurationScreen.this.hasPropsChanged = true;
                }
            }
        }
    }

    private class OptionKeyBindWidget
    extends Button {
        private final Props props;
        private boolean isEdited;
        private InputConstants.Key keyInput;

        public OptionKeyBindWidget(int x, int y, int w, Props props) {
            super(x, y, w, 20, (Component)Component.m_237115_((String)""), b -> {}, Button.f_252438_);
            this.props = props;
            this.isEdited = false;
            this.keyInput = InputConstants.Type.KEYSYM.m_84895_(ConfigurationScreen.this.config.getIntOrDefault(props));
            this.m_93666_((Component)Component.m_237113_((String)this.keyInput.m_84875_().getString()));
        }

        public void m_5691_() {
            boolean bl = this.isEdited = !this.isEdited;
            if (this.isEdited) {
                this.m_93666_((Component)Component.m_237113_((String)">").m_130946_(this.keyInput.m_84875_().getString()).m_130946_("<"));
            } else {
                this.m_93666_((Component)Component.m_237113_((String)this.keyInput.m_84875_().getString()));
            }
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            if (this.isEdited) {
                this.isEdited = false;
                this.keyInput = InputConstants.m_84827_((int)keyCode, (int)scanCode);
                this.m_93666_((Component)Component.m_237113_((String)this.keyInput.m_84875_().getString()));
                ConfigurationScreen.this.config.set(this.props, this.keyInput.m_84873_());
                if (!ConfigurationScreen.this.hasPropsChanged) {
                    ConfigurationScreen.this.hasPropsChanged = true;
                }
                return true;
            }
            return super.m_7933_(keyCode, scanCode, modifiers);
        }
    }

    private class OptionToggleWidget
    extends Button {
        private final Props props;

        public OptionToggleWidget(int x, int y, int w, Props props) {
            super(x, y, w, 20, (Component)Component.m_237115_((String)""), b -> {}, Button.f_252438_);
            this.props = props;
            boolean v = ConfigurationScreen.this.config.getBoolOrDefault(props);
            this.m_93666_((Component)Component.m_237115_((String)(v ? "gui.libraryferret.true" : "gui.libraryferret.false")));
        }

        public void m_5691_() {
            Configuration configSingleton = ConfigurationScreen.this.config;
            boolean v = !configSingleton.getBoolOrDefault(this.props);
            this.m_93666_((Component)Component.m_237115_((String)(v ? "gui.libraryferret.true" : "gui.libraryferret.false")));
            configSingleton.set(this.props, v);
            if (!ConfigurationScreen.this.hasPropsChanged) {
                ConfigurationScreen.this.hasPropsChanged = true;
            }
        }
    }

    private class OptionSliderWidget
    extends AbstractSliderButton {
        private final Props props;

        public OptionSliderWidget(int x, int y, int w, Props props) {
            super(x, y, w, 20, (Component)Component.m_237115_((String)""), 0.0);
            this.props = props;
            int v = ConfigurationScreen.this.config.getIntOrDefault(props);
            double p = Mth.m_14008_((double)v, (double)0.0, (double)100.0);
            this.f_93577_ = (p -= 0.0) / 100.0;
            this.m_5695_();
        }

        protected void m_5695_() {
            this.m_93666_((Component)Component.m_237115_((String)("gui.libraryferret.props.name." + this.props.getKey())).m_130946_(": ").m_7220_((Component)Component.m_237113_((String)String.valueOf(ConfigurationScreen.this.config.getIntOrDefault(this.props)))));
        }

        protected void m_5697_() {
            double var10000 = Mth.m_14008_((double)this.f_93577_, (double)0.0, (double)1.0);
            int v = (int)Mth.m_14139_((double)var10000, (double)0.0, (double)100.0);
            ConfigurationScreen.this.config.set(this.props, v);
            if (!ConfigurationScreen.this.hasPropsChanged) {
                ConfigurationScreen.this.hasPropsChanged = true;
            }
        }
    }
}

